================================================================================
TITLE "Lab1 Experiments"
================================================================================

-- Convert, normalize, rename, and report (if LaTeX is on) the
-- reported Lab1 surface sample used for the PVT experiments:
 
LMIX Lab1_Recombined_Oil: 1 Mole Lab1_Recombined_Oil

-- Simulate the single-stage separation experiment:

QIX FEED: Lab1_Recombined_Oil
TEMP 96 C, PRES 232.42 BARG
DFL ID "Lab1 Single-Stage Separation", BUBP WT ?SATPW?
TEMP      PRES      GOR 
C         BARG      SM3/M3
LTX       LTX       LTX
15          0       137
WTS                 10
END

-- Convert, normalize, and report the injection gas for the swelling experiment:

LMIX Lab1_Swelling_Gas 1 MOLE Lab1_Swelling_Gas

-- Simulate the swelling experiment. Include a fictitious critical mixture,
-- where all K-values converge to 1, to coax the regression toward placing
-- the critical mixture at that location.

QIX FEED: Lab1_Recombined_Oil
QIX INJECTANT: Lab1_Swelling_Gas
TEMP 96 C, PRESSURE 232.42 BARG
SWELL ID "Lab1 Swelling Test"
WFI       PSAT    DEN     FEED  LVF  K-C30+     MFI
          BARG    G/CC                           %
WTS         1     0.1           0.2  ?CRITKW?
X           Y       Y            Y           
0         232.42                 1
0.06563   272.47  0.653   M23    1
0.21770   397.42  0.580   M54    1
0.26890   425.37  0.561   M61    1
0.275                                   1  ; estimated critical mixture
0.30676   452.11  0.547   M65    0
0.45610   586.05  0.496   M78    0
0.50
0.55   
0.60
0.65   
0.70
0.75   
0.80
0.85   
0.90
0.95   
END

-- Repeat the first three stages of the swelling experiment, but with
-- viscosity measurements at the reported, undersaturated pressures:

QIX FEED: Lab1_Recombined_Oil
TEMP 96 C, PRESSURE 232.42 BARG
SWELL ID "Lab1 Viscosity Test"
WFI       PRES     LVIS      MFI
          PSIG     CP
WTS                ?LVISW?
                    Y         X
0.06563   6000     0.578
0.21770   6200     0.317
0.26890   6450     0.245
END

-- Simulate a constant composition expansion of the original oil:

QIX FEED: Lab1_Recombined_Oil
TEMP 96 C, SATP, PRES 232.42 BARG
CCE ID "P/V Test on Lab1 0% Solvent/Oil Mixture", BUBP WEIGHT ?SATPW?
PRES      LVF2    TEMP    LVOL    GOR     RV1
BARG       %      C       M3    SM3/M3
Wts       1.0              0       0
X          Y
240
235
232.42   100.0                        
212.01    91.9
206.64    91.3
200.84    90.4
194.43    89.4
186.16    84.8
151.68    76.2
128.24    69.0
111.83    63.5
 99.84    57.9
END

-- Simulate a constant composition expansion of first swollen mixture:

QIX FEED M23
TEMP 96 C, SATP, PRES 272.47 BARG
CCE ID "P/V Test on Lab1 23% Solvent/Oil Mixture", BUBP WEIGHT ?SATPW?
BASIS: 1.595 M3
PRES      LVF2   TEMP    LVOL    GOR     RV1
BARG       %      C       M3    SM3/M3
Wts       1.0              0       0
X          Y
285
280
275
272.47   100.0                        
241.66    83.5
235.39    83.0
214.43    79.2
155.82    65.4
101.63    49.6
 75.84    39.1
 60.67    31.1
END

-- Simulate a constant composition expansion of second swollen mixture:

QIX FEED M54
TEMP 96 C, SATP, PRES 397.42 BARG
CCE ID "P/V Test on Lab1 54% Solvent/Oil Mixture", BUBP WEIGHT ?SATPW?
BASIS: 2.291 M3
PRES      LVF2    TEMP    LVOL    GOR     RV1
BARG       %      C       M3    SM3/M3
Wts       1.0              0       0
X          Y
400
397.42    100.0                       
395.21    88.1                        
390.93    85.7                        
381.35    79.4
367.90    76.9
343.36    73.6
255.66    62.2
197.88    51.5
147.34    40.2
118.73    35.2
END

-- Simulate a constant composition expansion of third swollen mixture:

QIX FEED M61
TEMP 96 C, SATP, PRES 425.37 BARG
CCE ID "P/V Test on Lab1 61% Solvent/Oil Mixture", BUBP WEIGHT ?SATPW?
BASIS: 2.496 M3
PRES      LVF2   TEMP    LVOL    GOR     RV1
BARG       %      C       M3    SM3/M3
Wts       1.0              0       0
X          Y
440
435
430
425.37   100.0                        
421.96    88.6                        
415.75    83.1                        
410.10    79.3                              
398.86    75.2                              
388.45    69.7                              
378.18    69.6                              
368.52    66.0                              
350.18    65.9                              
333.36    62.8
270.76    56.5
218.22    51.2
END

-- Simulate a constant composition expansion of fourth swollen mixture.
-- Include the measured compositions and K-values at the final pressure,
-- but weight only the K-values of CO2, C1, C2, and C6+:

QIX FEED M65
TEMP 96 C, SATP, PRES 452.11 BARG
CCE ID "P/V Test on Lab1 65% Solvent/Oil Mixture", DEWP WEIGHT ?SATPW?
BASIS: 2.659 M3
PRES      LVF2   TEMP    LVOL    GOR     RV1
BARG       %      C       M3    SM3/M3
Wts       0.5              0       0
X          Y
480
475
470
465
460
455
452.11    0.0                         
438.02   40.3                         
431.89   40.0                         
426.23   41.0                         
420.10   42.6                             
414.24   43.5
402.86   46.1
381.69   48.5                              
362.39   49.4                              
314.68   48.5                              
259.10   45.9
222.29   42.5

PRES, BARG  X-N2        X-CO2       X-C1        X-C2        X-C3        X-I-C4      X-N-C4      X-I-C5      X-N-C5      X-C6-C7     X-C8-C9     X-C10-C13   X-C14-C19   X-C20-C29   X-C30+      X-C6+
222.29      0.00128311  0.0148051   0.411187    0.0846851   0.0898176   0.00424413  0.0515217   0.00611944  0.0289193   0.0732359   0.0436257   0.0628723   0.0513243   0.038888    0.0374717   0.29830
Wts         0           0           0           0           0           0           0           0           0           0           0           0           0           0           0           0

PRES, BARG  Y-N2        Y-CO2       Y-C1        Y-C2        Y-C3        Y-I-C4      Y-N-C4      Y-I-C5      Y-N-C5      Y-C6-C7     Y-C8-C9     Y-C10-C13   Y-C14-C19   Y-C20-C29   Y-C30+      Y-C6+
222.29      0.00390123  0.0207065   0.725229    0.0909288   0.0705223   0.00350111  0.0294093   0.00300095  0.0110035   0.0205065   0.00930294  0.00840266  0.00290092  0.00060019  8.38E-05    0.04220
Wts         0           0           0           0           0           0           0           0           0           0           0           0           0           0           0           0

PRES, BARG  K-N2        K-CO2       K-C1        K-C2        K-C3        K-I-C4      K-N-C4      K-I-C5      K-N-C5      K-C6-C7     K-C8-C9     K-C10-C13   K-C14-C19   K-C20-C29   K-C30+      K-C6+
222.29      3.040448598 1.398605886 1.763744963 1.073728436 0.785172394 0.824929962 0.570813851 0.49039618  0.380489846 0.2800065   0.213244487 0.133646455 0.056521375 0.01543381  0.002235482 0.14150
Wts         0           0.1         0.2         0.1         0           0           0           0           0           0           0           0           0           0           0           0

END

-- Simulate a constant composition expansion of final swollen mixture:

QIX FEED M78
TEMP 96 C, SATP, PRES 586.05 BARG
CCE ID "P/V Test on Lab1 78% Solvent/Oil Mixture", DEWP WEIGHT 1
BASIS: 3.319 M3
PRES      LVF2   TEMP    LVOL    GOR     RV1
BARG       %      C       M3    SM3/M3
Wts       0.3              0       0
X          Y
630
625
620
615
610
605
600
595
590
586.05    0.0
442.09   18.5
430.92   19.8
419.41   20.8
398.03   25.4
377.83   26.4
350.39   28.9
284.41   31.8
239.94   30.2
210.36   28.9
188.43   31.6
END
